﻿using System;
using VIRP.CRS.BO;

namespace VIRP.EFR.BO
{
    public static class AddressFactory
    {
        public static Address Create<T>(T source, string descriptor = null)
        {
            if (source is PATIENT_REG)
            {
                PATIENT_REG patientReg = source as PATIENT_REG;
                return new Address
                {
                    AddressType = AddressType.PatientPrimary,
                    AddressPart1 = patientReg.ADDRESS_LINE1,
                    AddressPart2 = patientReg.ADDRESS_LINE2,
                    AddressPart3 = patientReg.ADDRESS_LINE3,
                    City = patientReg.CITY,
                    Phone = patientReg.WORK_PHONE,
                    Zip = patientReg.POSTAL_CODE,
                    Country = patientReg.COUNTRY,
                    State = patientReg.STATE,
                    Name = descriptor
                };
            }
            else if (source is REGISTRY_DEMOGRAPHICS)
            {
                REGISTRY_DEMOGRAPHICS demo = source as REGISTRY_DEMOGRAPHICS;
                return new Address
                {
                    AddressType = AddressType.PatientSecondary,
                    AddressPart1 = demo.ADDRESS_LINE1,
                    AddressPart2 = demo.ADDRESS_LINE2,
                    AddressPart3 = demo.ADDRESS_LINE3,
                    City = demo.CITY,
                    Phone = demo.WORK_PHONE,
                    Zip = demo.POSTAL_CODE,
                    Country = demo.COUNTRY,
                    State = demo.STATE,
                    Name = descriptor
                };
            }
            else if (source is REFERRAL_REG && SafeDescriptorComparison(descriptor, "VAMC"))
            {
                REFERRAL_REG referral = source as REFERRAL_REG;
                return new Address
                {
                    AddressType = AddressType.ReferralVamcPrimary,
                    AddressPart1 = referral.ADDRESS_LINE1,
                    AddressPart2 = referral.ADDRESS_LINE2,
                    AddressPart3 = referral.ADDRESS_LINE3,
                    City = referral.CITY,
                    Zip = referral.POSTAL_CODE,
                    Country = referral.COUNTRY,
                    State = referral.STATE,
                    Name = referral.PATIENT.FULL_NAME
                };
            }
            else if (source is REFERRAL_REG && SafeDescriptorComparison(descriptor, "PROVIDER"))
            {
                REFERRAL_REG referral = source as REFERRAL_REG;
                return new Address
                {
                    AddressType = AddressType.ProviderReferral,
                    AddressPart1 = referral.PROVIDER_ADDRESS_LINE1,
                    AddressPart2 = referral.PROVIDER_ADDRESS_LINE2,
                    AddressPart3 = referral.PROVIDER_ADDRESS_LINE3,
                    City = referral.PROVIDER_CITY,
                    Phone = referral.PROVIDER_PHONE,
                    Zip = referral.PROVIDER_POSTAL_CODE,
                    State = referral.PROVIDER_STATE,
                    Country = referral.PROVIDER_COUNTRY,
                    Name = referral.PROVIDER_NAME
                };
            }
            else if (source is REFERRAL_REG && SafeDescriptorComparison(descriptor, "FACILITY"))
            {
                REFERRAL_REG referral = source as REFERRAL_REG;
                return new Address
                {
                    AddressType = AddressType.ProviderReferral,
                    AddressPart1 = referral.ADDRESS_LINE1,
                    AddressPart2 = referral.ADDRESS_LINE2,
                    AddressPart3 = referral.ADDRESS_LINE3,
                    City = referral.CITY,
                    Phone = referral.VAMC_CONTACT_PHONE,
                    Zip = referral.POSTAL_CODE,
                    State = referral.STATE,
                    Country = referral.COUNTRY,
                    Name = referral.VAMC_CONTACT_NAME,
                    Facility = descriptor
                };
            }
            else if (source is INTERPRETATION_LETTER && SafeDescriptorComparison(descriptor, "PATIENT"))
            {
                INTERPRETATION_LETTER letter = source as INTERPRETATION_LETTER;
                return new Address
                {
                    AddressType = AddressType.PatientLetter,
                    AddressPart1 = letter.PATIENT_ADDR1,
                    AddressPart2 = letter.PATIENT_ADDR2,
                    AddressPart3 = letter.PATIENT_ADDR3,
                    City = letter.PATIENT_CITY,
                    Phone = letter.PATIENT_PHONE,
                    Zip = letter.PATIENT_POSTAL,
                    Country = letter.PATIENT_COUNTRY,
                    State = letter.PATIENT_STATE,
                    Name = letter.PATIENT_NAME
                };
            }
            else if (source is INTERPRETATION_LETTER && SafeDescriptorComparison(descriptor, "PROVIDER"))
            {
                INTERPRETATION_LETTER letter = source as INTERPRETATION_LETTER;
                return new Address
                {
                    AddressType = AddressType.ProviderLetter,
                    AddressPart1 = letter.PROVIDER_ADDR1,
                    AddressPart2 = letter.PROVIDER_ADDR2,
                    AddressPart3 = letter.PROVIDER_ADDR3,
                    Facility = letter.PROVIDER_INSTITUTION_NAME,
                    City = letter.PROVIDER_CITY,
                    Phone = letter.PROVIDER_PHONE,
                    Zip = letter.PROVIDER_POSTAL,
                    State = letter.PROVIDER_STATE,
                    Country = letter.PROVIDER_COUNTRY,
                    Name = letter.PROVIDER_NAME
                };
            }
            else if (source is STD_INSTITUTION)
            {
                STD_INSTITUTION institution = source as STD_INSTITUTION;

                var result = new Address();

                if (!string.IsNullOrEmpty(institution.MAILINGADDRESSLINE1))
                {
                    result.AddressType = AddressType.ReferralVamcMailing;
                    result.AddressPart1 = institution.MAILINGADDRESSLINE1;
                    result.AddressPart2 = institution.MAILINGADDRESSLINE2;
                    result.AddressPart3 = institution.MAILINGADDRESSLINE3;
                    result.City = institution.MAILINGCITY;
                    result.Zip = institution.MAILINGPOSTALCODE;
                }
                else
                {
                    result.AddressType = AddressType.ReferralVamcStreet;
                    result.AddressPart1 = institution.STREETADDRESSLINE1;
                    result.AddressPart2 = institution.STREETADDRESSLINE2;
                    result.AddressPart3 = institution.STREETADDRESSLINE3;
                    result.City = institution.STREETCITY;
                    result.Zip = institution.STREETPOSTALCODE;
                }

                return result;
            }

            return null;
        }

        private static bool SafeDescriptorComparison(string descriptor, string expected)
        {
            if (string.IsNullOrEmpty(descriptor) || string.IsNullOrEmpty(expected))
                return false;

            return descriptor.Equals(expected, StringComparison.OrdinalIgnoreCase);
        }
    }
}
